---
generated_at: 2026-01-30 12:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-Wasm Test Runner

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `src/tests/Common/wasm-test-runner/index.html`（1行）
- E-02: `src/tests/Common/wasm-test-runner/WasmTestRunner.proj`（50行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | index.html は最小限の HTML 構造 | E-01（全体: 1行のみ） | ○ |
| C-02 | test-main.js を module として読み込み | E-01（`<script type='module' src='test-main.js'>`） | ○ |
| C-03 | WasmApp.InTree.props をインポート | E-02（6行目: `<Import Project="$(CORE_ROOT)\build\WasmApp.InTree.props" />`） | ○ |
| C-04 | WasmMainAssemblyFileName を設定 | E-02（27行目: `<WasmMainAssemblyFileName>$(TestAssemblyFileName)</WasmMainAssemblyFileName>`） | ○ |
| C-05 | WasmAppDir を設定 | E-02（28行目: `<WasmAppDir>$(AppDir)</WasmAppDir>`） | ○ |
| C-06 | WasmMainJSPath で test-main.js を参照 | E-02（29行目: `<WasmMainJSPath>$(CORE_ROOT)\runtime-test\test-main.js</WasmMainJSPath>`） | ○ |
| C-07 | WasmGenerateRunV8Script を有効化 | E-02（31行目: `<WasmGenerateRunV8Script>true</WasmGenerateRunV8Script>`） | ○ |
| C-08 | WasmAssembliesToBundle でアセンブリを指定 | E-02（36行目: `<WasmAssembliesToBundle Include="$(TestBinDir)\*.dll" />`） | ○ |
| C-09 | WasmAppBuilderTasksAssemblyPath を設定 | E-02（19行目: `<WasmAppBuilderTasksAssemblyPath>...WasmAppBuilder.dll</WasmAppBuilderTasksAssemblyPath>`） | ○ |
| C-10 | MonoAOTCompilerTasksAssemblyPath を設定 | E-02（20行目: `<MonoAOTCompilerTasksAssemblyPath>...MonoAOTCompiler.dll</MonoAOTCompilerTasksAssemblyPath>`） | ○ |
| C-11 | MonoTargetsTasksAssemblyPath を設定 | E-02（21行目: `<MonoTargetsTasksAssemblyPath>...MonoTargetsTasks.dll</MonoTargetsTasksAssemblyPath>`） | ○ |
| C-12 | IsBrowserWasmProject を true に設定 | E-02（17行目: `<IsBrowserWasmProject>true</IsBrowserWasmProject>`） | ○ |
| C-13 | WasmApp.InTree.targets をインポート | E-02（49行目: `<Import Project="$(CORE_ROOT)\build\WasmApp.InTree.targets" />`） | ○ |
| C-14 | 関連機能は Mono, WebAssembly Workload, WasmAppBuilder | E-04（28行目: 画面No 28 のマッピング） | ○ |

## 4) 不足情報（Unknown / Missing）

すべての主張に対して根拠が確認できました。不足情報はありません。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に根拠があり、ソースコードと整合しています

## 6) レビュアーチェックリスト（最小）

- [ ] index.html と WasmTestRunner.proj のコード内容が設計書の記述と一致しているか確認
- [ ] WasmAppBuilder によるビルドが正しく動作するか確認
- [ ] test-main.js が正しく読み込まれ、テストが実行されるか確認
- [ ] V8 実行スクリプトが正しく生成されるか確認
